#!/usr/bin/perl
#------------------------------------------------------------------------------
# Copyright and Licence
#------------------------------------------------------------------------------
# TrnsLng Version 2.01 for NT and Unix : Make your Web Site Multilingual
# Copyright (C) 2001 Rohitab Batra
#
# You may give exact copies of this script (software) to anyone. You may not charge
# any fee for the copy or use of this software, but you may charge a distribution fee
# that is reasonably related to any cost you incur distributing the software. You
# may not represent in any way that you are selling the software yourself.
# Permission is granted to use this script for private and commercial use. You
# may modify the script provided the licence is kept intact and you don not
# distribute a modified version of the script. You may not create derivative works
# based on the software. You may not rent or lease the software.
#
# If you would like any changes to be made in this script, please e-mail me.
#
# Author: Rohitab Batra
# Author e-mail: rohitab@rohitab.com
# Author Homepage: http://www.rohitab.com/
# Script Homepage: http://www.rohitab.com/cgiscripts/translingo.html
# Product Support: http://www.rohitab.com/support/
# Discussion Forum: http://www.rohitab.com/discuss/
# Mailing List: http://www.rohitab.com/mlist/
#------------------------------------------------------------------------------
#------------------------------------------------------------------------------
# User - Configuration - Make changes to this section
#------------------------------------------------------------------------------
$DataDirectory = "/websites/yourserver.com/html/translingo/";
				# This is the full path of the directory in which the TrnsLng
				# data files are stored. The path should end with a double backslash
				# "\\" character for  Windows NT/2K and a forwardslash "/" for *nix.
				# character. See the following 2 examples
				# /home/rohitab.com/webs/translingo/
				# D:\\inetpub\\rohitab.com\\translingo\\

$URLDataDirectory = "/translingo/";
				# This is the URL of the data directory. It must end with a fowardslash
				# character "/". So, for example, if the above data directory
				# /home/rohitab.com/webs/translingo/ is visible on the internet
				# as http://rohitab.com/translingo/, then you must enter "/translingo/"

@Referers=('rohitab.com', 'www.rohitab.com', 'yourserver.com', 'www.yourserver.com');
				# This is the list of domains that are allowed
				# to call this script. This is used, so that
				# people from other sites cannot use the script
				# directly from your server.

# DON'T CHANGE ANYTHING BELOW THIS LINE UNLESS YOU KNOW WHAT YOU'RE DOING !!

#------------------------------------------------------------------------------
# System - Configuration
#------------------------------------------------------------------------------
$ScriptVersion = "2.01";
$EngineFile = $DataDirectory . "engines.pl";
$TemplateFile = $DataDirectory . "templates.pl";
$ScriptLocation = $ENV{'SCRIPT_NAME'};
#------------------------------------------------------------------------------
# Function:			Main
# Description: 	Entry Point Function
# Parameterts:		NONE
#------------------------------------------------------------------------------
sub Main
{
	# get the input parameters
	&ReadParse;

	# determine what needs to be done
	my $Action = $in{'a'};

	# if we're displaying the wizard or translating pages
	if($Action eq "w" || $Action eq "f" || $Action eq "t")
	{
		# make sure that the required files are present
		if(!(-e $EngineFile))
		{
			PrintFileNotFoundError($EngineFile);
			exit;
		}
		if(!(-e $TemplateFile))

		{
			PrintFileNotFoundError($TemplateFile);
			return;
		}

		# include the files
		require $EngineFile;
		require $TemplateFile;

	}

	# if this is a translation request

   if($Action eq "f" || $Action eq "t") # user wants to translate
   {
		# make sure that the referrer is valid
		if(!&CheckReferer)
		{
			&PrintReferrerError;
			exit;
		}
	}

	# now do whatever needs to be done
	if($Action eq "f")
	{
		&PrintFramesPage;
	}
	elsif($Action eq "t")
	{
		&TranslatePage;
	}
   elsif($Action eq "w") # code generation wizard
   {
   	# we always show the next page, because the back and cancel button
   	# functionality is implemented in client-side javascript
   	if($in{'next'})
   	{
   		ShowWizardPage($in{'s'} + 1);
   	}
   	else
   	{
   		ShowWizardPage(0);
   	}
	}
	else # no action was specified, display the main page
	{
		&PrintMainPage;
	}
}
#------------------------------------------------------------------------------
# Function:			ReadParse
# Description:		Reads the input sent by the browser and parses the input variables
# Parameters:		Not Used
#------------------------------------------------------------------------------
sub ReadParse
{
	local (*in) = @_ if @_;
	local ($i, $loc, $key, $val);

	if($ENV{'REQUEST_METHOD'} eq "GET")
	{
		$in = $ENV{'QUERY_STRING'};
	}
	elsif($ENV{'REQUEST_METHOD'} eq "POST")
	{
		read(STDIN, $in, $ENV{'CONTENT_LENGTH'});
	}

	@in = split(/&/, $in);
	foreach $i (0 .. $#in)
	{
		$in[$i] =~ s/\+/ /g;
		($key, $val) = split(/=/, $in[$i], 2);
		$key =~ s/%(..)/pack("c", hex($1))/ge;
		$val =~ s/%(..)/pack("c", hex($1))/ge;
		$in{$key} .= "\0" if (defined($in{$key}));
		$in{$key} .= $val;
	}
}
#------------------------------------------------------------------------------
# Function:			CheckReferer
# Description:		This function checks if the referer is from the list of valid
#						referers
# Parameters:		RETURN Number - 1 if the referrer is valid, 0 otherwise
#------------------------------------------------------------------------------
sub CheckReferer
{
	my $Valid = 0;
	if($ENV{'HTTP_REFERER'})
	{
		foreach (@Referers)
		{
			if($ENV{'HTTP_REFERER'} =~ /$_/i)
			{
				$Valid = 1;
				last;
			}
		}
	}
	else
	{
		$Valid = 1;
	}
	return $Valid;
}
#------------------------------------------------------------------------------
# Function:			ReadTemplateFile
# Description:		This function reads and returns the specified template file
#						from the data directory. It also replaces pre-defined tags in it
# Parameters:		IN String - Filename of template file in the data directory
#						RETURN String - Template File
#------------------------------------------------------------------------------
sub ReadTemplateFile
{
	local($Filename) = @_;

	# get the full path of the template file and make sure it is present
	my $TempateFilename = $DataDirectory . $Filename;
	if(!(-e $TempateFilename))
	{
		PrintFileNotFoundError($TempateFilename);
		exit;
	}

	my $Data;

	# Read the Template File
	open(TEMPLATEFILE, $TempateFilename);
	while(<TEMPLATEFILE>)
	{
		$Data .= $_;
	}
	close(TEMPLATEFILE);

	# Replace Variables
	$Data =~ s/\$EngineVersion/$EngineVersion/g;
	$Data =~ s/\$EngineDate/$EngineDate/g;
	$Data =~ s/\$ScriptLocation/$ScriptLocation/g;
	$Data =~ s/\$ScriptVersion/$ScriptVersion/g;

	my $Image = $URLDataDirectory . "translingo.jpg";
	$Data =~ s/translingo.jpg/$Image/g;

	return $Data;

}
#------------------------------------------------------------------------------
# Function:			ShowWizardPage
# Description:		This function displays the HTML Code Generator Wizard for the
#						specified step.
# Parameters:		IN Number - Wizard Page Number to be displayed.
#------------------------------------------------------------------------------
sub ShowWizardPage
{
	local($Page) = @_;

	return &WizardStep1 if($Page == 1);
	return &WizardStep2 if($Page == 2);
	return &WizardStep3 if($Page == 3);
	return &WizardStep4 if($Page == 4);
	return &WizardStep5 if($Page == 5);
	return &WizardStep6 if($Page == 6);
	return &WizardStep7 if($Page == 7);

	return &WizardStep0;
}
#------------------------------------------------------------------------------
# Function:			WizardStep0
# Description:		This function displays Step 0 (Code Generator Wizard) of the
#						HTML Code Generator Wizard. It provides a descriptoin of
#						the wizard.
# Parameters:		NONE
#------------------------------------------------------------------------------
sub WizardStep0
{
	my $Data = ReadTemplateFile("page0.html");

	# display the wizard
	print "Content-type: text/html\n\n";
	print $Data;
}
#------------------------------------------------------------------------------
# Function:			WizardStep1
# Description:		This function displays Step 1 (Select Page URL) of the
#						HTML Code Generator Wizard. It allows the user to enter a
#						URL for translation.
# Parameters:		NONE
#------------------------------------------------------------------------------
sub WizardStep1
{
	my $Data = ReadTemplateFile("page1.html");

	# display the wizard
	print "Content-type: text/html\n\n";
	print $Data;
}
#------------------------------------------------------------------------------
# Function:			WizardStep2
# Description:		This function displays Step 2 (Select Website Language) of the
#						HTML Code Generator Wizard. It displays a list of source
#						languages from which a page can be translated and allows the
#						user to select a single language for translation.
# Parameters:		NONE
#------------------------------------------------------------------------------
sub WizardStep2
{
	my $i;
	my $Data;
	my $HTMLLanguageList;
	my @SourceLanguages;

	# Create the HTML tag for the language List
	@SourceLanguages = &GetSourceLanguageList;
	foreach $i(@SourceLanguages)
	{
		if($i eq "English") # select english as the default language
		{
			$HTMLLanguageList .= "<option selected>$i</option>";
		}
		else
		{
			$HTMLLanguageList .= "<option>$i</option>";
		}
	}

	# Get the template file and fill it up
	$Data = ReadTemplateFile("page2.html");
	$Data =~ s/<option>\$SourceLanguage<\/option>/$HTMLLanguageList/;

	# set the data to be passed to the next page
	my $HiddenFields = qq/<input type="hidden" name="url" value="$in{'url'}">/;
	$Data =~ s/\$HiddenFields/$HiddenFields/;

	# display the wizard
	print "Content-type: text/html\n\n";
	print $Data;
}
#------------------------------------------------------------------------------
# Function:			WizardStep3
# Description:		This function displays Step 3 (Select Target Languages) of the
#						HTML Code Generator Wizard. It displays a list of target
#						languages for the selected source language and allows the user
#						to select the languages that a page should be translated to
# Parameters:		NONE
#------------------------------------------------------------------------------
sub WizardStep3
{
	my $HTMLLanguageList;
	my $SourceLanguage;
	my @TargetLanguages;

	# Get the input data from the previous step
	$SourceLanguage = $in{'src'};

	# Create the HTML tag for the language List
	@TargetLanguages = GetTargetLanguageList($SourceLanguage);
	foreach $i(@TargetLanguages)
	{
		$HTMLLanguageList .= "<option>$i</option>";
	}

	# Get the template file and fill it up
	$Data = ReadTemplateFile("page3.html");
	$Data =~ s/<option>\$TargetLanguages<\/option>/$HTMLLanguageList/;
	$Data =~ s/\$SourceLanguage/$SourceLanguage/;

	# set the data to be passed to the next page
	my $HiddenFields = qq/<input type="hidden" name="url" value="$in{'url'}">/; # Step 1
	$HiddenFields .= qq/<input type="hidden" name="src" value="$SourceLanguage">/; # Step 2
	$Data =~ s/\$HiddenFields/$HiddenFields/;

	# display the wizard
	print "Content-type: text/html\n\n";
	print $Data;
}
#------------------------------------------------------------------------------
# Function:			WizardStep4
# Description:		This function displays Step 4 (Select Engines) of the
#						HTML Code Generator Wizard. It displays a list of engines for
#						each target language and allows the user to select the engine
#						to be used for translating to a particular language.
# Parameters:		NONE
#------------------------------------------------------------------------------
sub WizardStep4
{
	my $HTMLCode;

	# get the input data from the previous step
   my $SourceLanguage = $in{'src'};
   my $TargetLanguages = $in{'target'};

   # create the list of target languages, seperated by '|'
   $TargetLanguages =~ s/\0/\|/g;

	# for each target language
	my @TargetLanguages = split(/\|/, $TargetLanguages);
   foreach $TargetLanguage(@TargetLanguages)
   {
   	my $LanguagePair = $SourceLanguage . '|' . $TargetLanguage;
   	my @EngineList;
   	my $EngineList;

   	# for each engine
   	foreach $Engine(sort keys %$Engines)
   	{
   		# if the engine supports this language pair
   		if($Engines->{$Engine}->{LANG}->{$LanguagePair} ne "")
   		{
   			# add it to the list
            push(@EngineList, $Engines->{$Engine}->{NAME});
   		}
   	}

   	# create a string containing the list of supported engines seperated by '|'
      foreach $Value(@EngineList)
      {
         $EngineList .= $Value . '|';
      }
      chop($EngineList); # remove the trailing '|'

      # generate the HTML code
   	$HTMLCode .= qq/<option value="$EngineList">$TargetLanguage<\/option>/;
   }

 	# get the template and fill it up
 	$Data = ReadTemplateFile("page4.html");
 	$Data =~ s/<option>\$SelectEngines<\/option>/$HTMLCode/;

	# set the data to be passed to the next page
	my $HiddenFields = qq/<input type="hidden" name="url" value="$in{'url'}">/; # Step 1
	$HiddenFields .= qq/<input type="hidden" name="src" value="$SourceLanguage">/; # Step 2
	$Data =~ s/\$HiddenFields/$HiddenFields/;

	# display the wizard
	print "Content-type: text/html\n\n";
	print $Data;
}
#------------------------------------------------------------------------------
# Function:			WizardStep5
# Description:		This function displays Step 5 (Select Template) of the
#						HTML Code Generator Wizard. It displays a list of templates
#						that can be used for generating HTML code.
# Parameters:		NONE
#------------------------------------------------------------------------------
sub WizardStep5
{
	my $Data;

   # get the list of templates
   $HTMLTemplates = '<table border="0" width="100%"><tr>';
   my $i = 1;
  	foreach $Template (sort keys %$Templates)
	{
		if($i % 2) # if two columns have been displayed
		{
			$HTMLTemplates .= "</tr><tr>"; # move on to the next row
		}
		$HTMLTemplates .= "<td>";
      $HTMLTemplates .= qq/<input type="radio" name="template" value="$Template">$Templates->{$Template}->{NAME}/;
      $HTMLTemplates .= "</td>";
		$i++;
	}
	$HTMLTemplates .= "</tr></table>";

   # get the template and fill it up
	$Data = ReadTemplateFile("page5.html");
	$Data =~ s/\$HTMLTemplates/$HTMLTemplates/;

	# set the data to be passed to the next page
	my $HiddenFields = qq/<input type="hidden" name="url" value="$in{'url'}">/; # Step 1
	$HiddenFields .= qq/<input type="hidden" name="src" value="$in{'src'}">/; # Step 2
	$HiddenFields .= qq/<input type="hidden" name="targetlanguages" value="$in{'targetlanguages'}">/; # Step 3
	$HiddenFields .= qq/<input type="hidden" name="targetengines" value="$in{'targetengines'}">/; # Step 4
	$Data =~ s/\$HiddenFields/$HiddenFields/;

	# display the wizard
	print "Content-type: text/html\n\n";
	print $Data;
}
#------------------------------------------------------------------------------
# Function:			WizardStep6
# Description:		This function displays Step 6 (Confirm Selections) of the
#						HTML Code Generator Wizard. It displays the input of all the
#						previous steps.
# Parameters:		NONE
#------------------------------------------------------------------------------
sub WizardStep6
{
	my $Data;
	my $TargetLanguages;
	my $TargetEngines;

	# format the languages and engines
	($TargetLanguages = $in{'targetlanguages'}) =~ s/\|/, /g;
   ($TargetEngines = $in{'targetengines'}) =~ s/\|/, /g;

   # get the template and fill it up
	$Data = ReadTemplateFile("page6.html");
	$Data =~ s/\$SourceLanguage/$in{'src'}/;
	$Data =~ s/\$TargetLanguages/$TargetLanguages/;
	$Data =~ s/\$TargetEngines/$TargetEngines/;
	$Data =~ s/\$Template/$Templates->{$in{'template'}}->{NAME}/;
	if($in{'url'} ne "") # a page URL was specified
	{
		$Data =~ s/\$PageURL/<a href="$PageURL" target="_new">$in{'url'}<\/a>/;
	}
	else # no URL was specified
	{
		$Data =~ s/\$PageURL/(Page on which code is placed)<\/a>/;
	}

	# set the data to be passed to the next page
	my $HiddenFields = qq/<input type="hidden" name="url" value="$in{'url'}">/; # Step 1
	$HiddenFields .= qq/<input type="hidden" name="src" value="$in{'src'}">/; # Step 2
	$HiddenFields .= qq/<input type="hidden" name="targetlanguages" value="$in{'targetlanguages'}">/; # Step 3
	$HiddenFields .= qq/<input type="hidden" name="targetengines" value="$in{'targetengines'}">/; # Step 4
	$HiddenFields .= qq/<input type="hidden" name="template" value="$in{'template'}">/; # Step 5
	$Data =~ s/\$HiddenFields/$HiddenFields/;

	# display the wizard
	print "Content-type: text/html\n\n";
	print $Data;
}
#------------------------------------------------------------------------------
# Function:			WizardStep7
# Description:		This function displays Step 7 (Copy-Paste HTML Code) of the
#						HTML Code Generator Wizard. It generates code based on the
#						input of the previous steps.
# Parameters:		NONE
#------------------------------------------------------------------------------
sub WizardStep7
{
	my $Data;
	my $Pair;
	my $TempCode;
	my $TargetEngine;
	my $TargetLanguage;
	my $TargetEngineId;

	# get the input data from all steps
	my $PageURL = $in{'url'}; # Step 1
	my $SourceLanguage = $in{'src'}; # Step 2
	my $TargetLanguages = $in{'targetlanguages'}; # Step 3
	my $TargetEngines = $in{'targetengines'}; # Step 4
   my $Template = $in{'template'}; # Step 5

   # get the template to be used for generating code
   my $CodeTemplate = $Templates->{$Template};

   # get the list of languages and corresponding engines
   my @TargetLanguages = split(/\|/, $TargetLanguages);
   my @TargetEngines = split(/\|/, $TargetEngines);

	my @MiddleCode;
   # for each language in the list
	for(my $Index = 0; $Index < @TargetLanguages; $Index++)
	{
		# get the engine ID
	  	$TargetEngine = @TargetEngines[$Index];
		foreach $Engine (sort keys %$Engines)
		{
      	if($Engines->{$Engine}->{NAME} eq $TargetEngine)
      	{
            $TargetEngineId = $Engine;
            last;
      	}
		}

		# create the language pair
		$TargetLanguage = @TargetLanguages[$Index];
   	$Pair = URLEncode($Engines->{$TargetEngineId}->{LANG}->{$SourceLanguage . '|' . $TargetLanguage});

   	# create the HTML code
		$TempCode = $CodeTemplate->{MIDCODE};
		$TempCode =~ s/\$Engine/$TargetEngineId/g;
		$TempCode =~ s/\$Pair/$Pair/g;
		$TempCode =~ s/\$TargetLanguage/$TargetLanguage/g;
		push(@MiddleCode, $TempCode);
	}

	# create the HTML Code
   my $HTMLCode = "<!-- TrnsLng $ScriptVersion Begin -->\n";
   $HTMLCode .= $CodeTemplate->{STARTCODE};
   $HTMLCode .= join($CodeTemplate->{SEPERATOR}, @MiddleCode);
   $HTMLCode .= $CodeTemplate->{ENDCODE};
   $HTMLCode .= "\n<!-- TrnsLng $ScriptVersion End -->";

 	# replace the tags in the generated HTML code
	my $EncodedPageURL = URLEncode($PageURL);
	my $NumLanguages = @TargetLanguages;
	$HTMLCode =~ s/\$ScriptLocation/$ScriptLocation/g;
	$HTMLCode =~ s/\$PageURL/$EncodedPageURL/g;
	$HTMLCode =~ s/\$NumLanguages/$NumLanguages/g;
   $HTMLCode =~ s/\$SourceLanguage/$SourceLanguage/g;

   # get the template and fill it up
	$Data = ReadTemplateFile("page7.html");
	$Data =~ s/\$HTMLCode/$HTMLCode/;

	# display the wizard
	print "Content-type: text/html\n\n";
	print $Data;
}
#------------------------------------------------------------------------------
# Function:			GetTargetLanguageList
# Description:		This function returns the list of languages to which a page
#						can be translated.
# Parameters:		IN String - Source Language
#						RETURN String Array - List of languages
#------------------------------------------------------------------------------
sub GetTargetLanguageList
{
	local($SourceLanguage) = @_;

	my @Pair;
	my $Engine;
	my @LanguageList;
	my $LanguagePair;
	my $EngineLanguages;

   # For each engine
	foreach $Engine (sort keys %$Engines)
	{
		# get the list of language pairs for the current engine
		$EngineLanguages = $Engines->{$Engine}->{LANG};

		# for each language pair, get the source and target languages
		foreach $LanguagePair(sort keys %$EngineLanguages)
		{
			@Pair = split(/\|/, $LanguagePair);

			# if the source language matches what we're looking for
			if($Pair[0] eq $SourceLanguage)
			{
				push(@LanguageList, $Pair[1]); # add the target language
			}
		}
	}

	# Sort and remove duplicate languages
	$PrevLang = '?';
	@LanguageList = grep($_ ne $PrevLang && ($PrevLang = $_), sort @LanguageList);

	return @LanguageList;
}
#------------------------------------------------------------------------------
# Function:			GetSourceLanguageList
# Description:    This function returns a list of languages from which a page
#						can be translated. This list is sorted.
# Parameters:     RETURN String Array - List of languages
#------------------------------------------------------------------------------
sub GetSourceLanguageList
{
	my @Pair;
	my $Engine;
	my @LanguageList;
	my $LanguagePair;
	my $EngineLanguages;

   # For each engine
	foreach $Engine (sort keys %$Engines)
	{
		# get the list of language pairs for the current engine
		$EngineLanguages = $Engines->{$Engine}->{LANG};

		#for each language pair, get the source language
		foreach $LanguagePair(sort keys %$EngineLanguages)
		{
			@Pair = split(/\|/, $LanguagePair);
			push(@LanguageList, $Pair[0]); # add the source language
		}
	}

	# Sort and remove duplicate languages
	$PrevLang = '?';
	@LanguageList = grep($_ ne $PrevLang && ($PrevLang = $_), sort @LanguageList);

	return @LanguageList;
}
#------------------------------------------------------------------------------
# Function:			URLEncode
# Description: 	This function encodes the specified URL or text.
# Parameters:		IN String - URL/Text to be encoded
#						RETURN String - Encoded URL/Text
#------------------------------------------------------------------------------
sub URLEncode
{
	local($Source) = @_;
	$Source =~ s/([^a-zA-Z0-9])/'%'.unpack("H*",$1)/eg;
	return $Source;
}
#------------------------------------------------------------------------------
# Function:			URLDecode
# Description: 	This function decodes the specified URL or text.
# Parameters:		IN String - URL/Text to be decoded
#						RETURN String - Decoded URL/Text
#------------------------------------------------------------------------------
sub URLDecode
{
	local($Source) = @_;
	$Source =~ s/%(..)/pack("c", hex($1))/ge;
	return $Source
}
#------------------------------------------------------------------------------
# Function:			PrintFramesPage
# Description:		This function prints out a frames page with 2 frames. Frames
#						are used only for URL hiding.
# Parameters:		NONE
#------------------------------------------------------------------------------
sub PrintFramesPage
{
	# get the values for the tags
	my $Engine = $in{'e'};
   my $PageURL = URLEncode($in{'u'} ? $in{'u'} : $ENV{'HTTP_REFERER'});
   my $Pair = URLEncode($in{'p'});

	my $TranslationURL = "$ScriptLocation?a=t&e=$Engine&p=$Pair&u=$PageURL";

	# get the frames page template and fill it up
	my $FramesPage = ReadTemplateFile("frames.html");
	$FramesPage =~ s/\$TranslationURL/$TranslationURL/g;

	# print out the page
	print "Content-type: text/html\n\n";
	print $FramesPage;
}
#------------------------------------------------------------------------------
# Function:			TranslatePage
# Description:		This function is called to translate a page. It creates the
#						URL for translation and then redirects the browser to that
#						page.
# Parameters:		NONE
#------------------------------------------------------------------------------
sub TranslatePage
{
	my ($TargetUrl, $TargetEngine, $TargetLanguage);

	# get the input parameters
	my $Engine = URLDecode($in{'e'});
   my $Pair = URLDecode($in{'p'});
	my $PageURL = URLDecode($in{'u'});
   if($Engines->{$Engine}->{ENCODE} == 1)
   {
   	$PageURL = URLEncode($PageURL);
   }

   # create the URL for the translated page
   my $TargetURL = $Engines->{$Engine}->{PATH};
   $TargetURL =~ s/\$LANG/$Pair/g;
   $TargetURL =~ s/\$URL/$PageURL/g;

	# make sure the url has a http:// before it
	#$TargetUrl = "http://".$InputUrl unless ($InputUrl =~ m/^http:\/\//);

	# translate it
	#print "Content-Type: text/html\n\n";
	print "Location: $TargetURL\n\n";
}

#------------------------------------------------------------------------------
# Function:			PrintReferrerError
# Description:		This function is used to display an error if the script is
#						called by an invalid referrer
# Parameters:		NONE
#------------------------------------------------------------------------------
sub PrintReferrerError
{
	my $ErrorDescription = qq!
You do not have permission to call this script from <font color="red">$ENV{'HTTP_REFERER'}</font>.
Please install this script on your own server if you wish to use it. You can get the
script from the <a href="http://www.rohitab.com/cgiscripts/translingo.html">TrnsLng Homepage</a>.
!;
	# read the template and fill it up
	my $Data = &GetErrorTemplate;
	$Data =~ s/\$ErrorHeaderLeft/Referrer/;
	$Data =~ s/\$ErrorHeaderRight/Error/;
	$Data =~ s/\$ErrorDescription/$ErrorDescription/;

	# display the error
	print "Content-type: text/html\n\n";
	print $Data;
}
#------------------------------------------------------------------------------
# Function:			PrintMainPage
# Description:		This function displays the main page for the script, which
#						allows the user to run the HTML code generator wizard
# Parameters:		NONE
#------------------------------------------------------------------------------
sub PrintMainPage
{
	# get the main page file
	$Data = ReadTemplateFile("main.html");

	# display the page
	print "Content-type: text/html\n\n";
	print $Data;
}

#------------------------------------------------------------------------------
# Function:			PrintFileNotFoundError
# Description:		This function is used to display a file not found error
# Parameters:		IN String - Filename of the file that could not be found
#------------------------------------------------------------------------------
sub PrintFileNotFoundError
{
	local($Filename) = @_;

	my $ErrorDescription = qq!
The file <font color="red"><b>$Filename</b></font> could not be found. Please make
sure that the file is in the specified path. If it is, them make sure that the file
is readable. If the file is missing, you can download it from the
<a href="$ScriptHomepage">TrnsLng Homepage</a>
<p>
You may also need to change the following configuration variables in the script:<br>
<b>\$DataDirectory</b> = $DataDirectory<br>
<b>\$URLDataDirectory</b> = $URLDataDirectory<br>
This script is running from $ScriptLocation
!;

	# read the template and fill it up
	my $Data = &GetErrorTemplate;
	$Data =~ s/\$ErrorHeaderLeft/Missing/;
	$Data =~ s/\$ErrorHeaderRight/File/;
	$Data =~ s/\$ErrorDescription/$ErrorDescription/;

	# display the error
	print "Content-type: text/html\n\n";
	print $Data;
}

#------------------------------------------------------------------------------
# Function:			GetErrorTemplate
# Description:		This function returns a template file that is used to display
#						errors.
# Parameters:		RETURN String - Error Template
#------------------------------------------------------------------------------
sub GetErrorTemplate
{
	return qq~
<html>
<head>
<meta name="GENERATOR" content="Microsoft FrontPage 5.0">
<meta name="ProgId" content="FrontPage.Editor.Document">
<meta http-equiv="Content-Type" content="text/html; charset=windows-1252">
<title>TrnsLng Version $ScriptVersion</title>
<style>
<!--
p {font-family:Verdana;font-size:8pt}
body {background-color:#ffffff;font-family:Verdana;font-size:8pt}
td		{font-family:Verdana;font-size:8pt}
td.headleft {font-size: 10pt; font-weight: bold; background-color: #63309C; color: #FFFFFF;}
td.headright {font-size: 10pt; font-weight:bold; color: #63309C}
-->
</style>
</head>
<body>
<center><font size="6">
<a href="http://www.rohitab.com/cgiscripts/translingo.html" style="text-decoration:none; color:#63309C">
TrnsLng</a></font><br>
<font size="1">Version $ScriptVersion,  2001 <a href="http://www.rohitab.com">Rohitab
Batra</a> </font></center>
<br>
<table border="1" cellspacing="0" bordercolor="#63309C">
  <tr>
    <td class="headleft">\$ErrorHeaderLeft</td>
    <td class="headright">\$ErrorHeaderRight</td>
  </tr>
</table>
<br>
\$ErrorDescription
<p>
<hr color="63309C"><center>
<a href="http://www.rohitab.com/cgiscripts/translingo.html">TrnsLng Homepage</a>
| <a href="http://www.rohitab.com/discuss/forums.cgi?forum=7">Discussion Forum</a>
| <a href="http://www.rohitab.com/mlist/">Mailing List</a> |
<a href="http://www.rohitab.com/support/">Product Support</a> |
<a href="http://www.rohitab.com/support/faq.html">Frequently Asked Questions</a>
</center>
</body>
</html>
~
}

#------------------------------------------------------------------------------
# EntryPoint:	Application Entry Point
#------------------------------------------------------------------------------
&Main;
