#------------------------------------------------------------------------------
# TrnsLng Engines File
#------------------------------------------------------------------------------
#
# Template Format
#
# NAME:	Name of the template that should be displayed in the wizard
# PATH:	URL used to translate a page
# LANG:	List of languages available for translation
#			'Source Language|Target Language'	=>		'$LANG'
# ENCODE: Set to 1 if the $URL in the PATH should be encoded
#
# The tags $LANG and $URL will automatically be replaced in the PATH
#
# If you add a new engine, make sure that you add a new entry to the
# $Engines list, otherwise the engine will not be available.

$EngineVersion = "3.1";
$EngineDate = "10 July 2003";

$Google = {
NAME	=> 'Google',
PATH	=> 'http://translate.google.com/translate?hl=en&langpair=$LANG&u=$URL',
ENCODE => 0,

LANG => {
	'English|German' => 'en|de',
	'English|French' => 'en|fr',
	'English|Spanish' => 'en|es',
	'English|Italian' => 'en|it',
	'English|Portuguese' => 'en|pt',
	'German|English' => 'de|en',
	'German|French' => 'de|fr',
	'Spanish|English' => 'es|en',
	'French|German' => 'fr|de',
	'French|English' => 'fr|en',
	'Italian|English' => 'it|en',
	'Portuguese|English' => 'pt|en'
	}
};

$Reverso = {
NAME => 'Reverso',
PATH => 'http://trans.voila.fr/ano?anolg=$LANG&anotop=1&anourl=$URL',
ENCODE => 0,

LANG => {
	'English|French' => '524289',
	'English|Spanish' => '2097153',
	'English|Russian' => '131073',
	'French|English' => '65544',
	'German|French' => '524292',
	'French|German' => '262152',
	'Russian|French' => '524290',
	'French|Russian' => '131080',
	'Russian|English' => '65538',
	'German|English' => '65540',
	'Russian|German' => '262146',
	'Italian|Russian' => '131088'
	}
};

$Ajeeb = {
NAME => 'Ajeeb',
PATH => 'http://tarjim.ajeeb.com/tarjimtrans.asp?ol=$LANG&sentence=$URL',
ENCODE => 0,

LANG => {
	'English|Arabic' => '1'
	#'Arabic|English' => '0'
	}
};

$Tsail = {
NAME => 'T-Sail',
PATH => 'http://www.t-mail.com/cgi-bin/tsail?url=$URL&sail=full&lp=$LANG&requestType=T-Sail',
ENCODE => 0,

LANG => {
	'Chinese Simplified|English' => 'zh-en',
	'English|Chinese Simplified' => 'en-zh',
	'English|Chinese Traditional' => 'en-tw',
	'English|French' => 'en-fr',
	'English|German' => 'en-de',
	'English|Italian' => 'en-it',
	'English|Japanese' => 'en-ja',
	'English|Korean' => 'en-ko',
	'English|Portuguese' => 'en-pt',
	'English|Spanish' => 'en-es',
	'French|English' => 'fr-en',
	'French|German' => 'fr-de',
	'German|English' => 'de-en',
	'German|French' => 'de-fr',
	'Italian|English' => 'it-en',
	'Japanese|English' => 'ja-en',
	'Korean|English' => 'ko-en',
	'Portuguese|English' => 'pt-en',
	'Russian|English' => 'ru-en',
	'Spanish|English' => 'es-en'
	}
};

$Worldlingo = {
NAME => 'WorldLingo',
PATH => 'http://www.worldlingo.com/wl/Translate?wl_lp=$LANG&wl_fl=2&wl_url=$URL',
ENCODE => 0,

LANG => {
	'English|Chinese' => 'EN-ZH',
	'English|French' => 'EN-FR',
	'English|German' => 'EN-DE',
	'English|Italian' => 'EN-IT',
	'English|Japanese' => 'EN-JA',
	'English|Korean' => 'EN-KO',
	'English|Brazilian Portuguese' => 'EN-PT',
	'English|Dutch' => 'EN-NL',
	'English|Spanish' => 'EN-ES',
	'Chinese|English' => 'ZH-EN',
	'Chinese|French' => 'ZH-FR',
	'Chinese|German' => 'ZH-DE',
	'Chinese|Italian' => 'ZH-IT',
	'Chinese|Japanese' => 'ZH-JA',
	'Chinese|Korean' => 'ZH-KO',
	'Chinese|Brazilian Portuguese' => 'ZH-PT',
	'Chinese|Dutch' => 'ZH-NL',
	'Chinese|Spanish' => 'ZH-ES',
	'French|English' => 'FR-EN',
	'French|Chinese' => 'FR-ZH',
	'French|German' => 'FR-DE',
	'French|Italian' => 'FR-IT',
	'French|Japanese' => 'FR-JA',
	'French|Korean' => 'FR-KO',
	'French|Brazilian Portuguese' => 'FR-PT',
	'French|Dutch' => 'FR-NL',
	'French|Spanish' => 'FR-ES',
	'German|English' => 'DE-EN',
	'German|Chinese' => 'DE-ZH',
	'German|French' => 'DE-FR',
	'German|Italian' => 'DE-IT',
	'German|Japanese' => 'DE-JA',
	'German|Korean' => 'DE-KO',
	'German|Brazilian Portuguese' => 'DE-PT',
	'German|Dutch' => 'DE-NL',
	'German|Spanish' => 'DE-ES',
	'Italian|English' => 'IT-EN',
	'Italian|Chinese' => 'IT-ZH',
	'Italian|French' => 'IT-FR',
	'Italian|German' => 'IT-DE',
	'Italian|Japanese' => 'IT-JA',
	'Italian|Korean' => 'IT-KO',
	'Italian|Brazilian Portuguese' => 'IT-PT',
	'Italian|Dutch' => 'IT-NL',
	'Italian|Spanish' => 'IT-ES',
	'Japanese|English' => 'JA-EN',
	'Japanese|Chinese' => 'JA-ZH',
	'Japanese|French' => 'JA-FR',
	'Japanese|German' => 'JA-DE',
	'Japanese|Italian' => 'JA-IT',
	'Japanese|Korean' => 'JA-KO',
	'Japanese|Brazilian Portuguese' => 'JA-PT',
	'Japanese|Dutch' => 'JA-NL',
	'Japanese|Spanish' => 'JA-ES',
	'Korean|English' => 'KO-EN',
	'Korean|Chinese' => 'KO-ZH',
	'Korean|French' => 'KO-FR',
	'Korean|German' => 'KO-DE',
	'Korean|Italian' => 'KO-IT',
	'Korean|Japanese' => 'KO-JA',
	'Korean|Brazilian Portuguese' => 'KO-PT',
	'Korean|Dutch' => 'KO-NL',
	'Korean|Spanish' => 'KO-ES',
	'Portuguese|English' => 'PT-EN',
	'Portuguese|Chinese' => 'PT-ZH',
	'Portuguese|French' => 'PT-FR',
	'Portuguese|German' => 'PT-DE',
	'Portuguese|Italian' => 'PT-IT',
	'Portuguese|Japanese' => 'PT-JA',
	'Portuguese|Korean' => 'PT-KO',
	'Portuguese|Dutch' => 'PT-NL',
	'Portuguese|Spanish' => 'PT-ES',
	'Russian|English' => 'RU-EN',
	'Russian|Chinese' => 'RU-ZH',
	'Russian|French' => 'RU-FR',
	'Russian|German' => 'RU-DE',
	'Russian|Italian' => 'RU-IT',
	'Russian|Japanese' => 'RU-JA',
	'Russian|Korean' => 'RU-KO',
	'Russian|Brazilian Portuguese' => 'RU-PT',
	'Russian|Spanish' => 'RU-ES',
	'Spanish|English' => 'ES-EN',
	'Spanish|Chinese' => 'ES-ZH',
	'Spanish|French' => 'ES-FR',
	'Spanish|German' => 'ES-DE',
	'Spanish|Italian' => 'ES-IT',
	'Spanish|Japanese' => 'ES-JA',
	'Spanish|Korean' => 'ES-KO',
	'Spanish|Brazilian Portuguese' => 'ES-PT',
	'Spanish|Dutch' => 'ES-NL'
	}
};

$Paralink = {
NAME => 'Paralink Translation',
PATH => 'http://translation2.paralink.com/urlbot.asp?direction=$LANG&template=Default&autotranslate=true&url=$URL',
ENCODE => 0,

LANG => {
	'English|French' => '524289',
	'English|German' => '262145',
	'English|Russian' => '131073',
	'English|Spanish' => '2097153',
	'French|English' => '65544',
	'French|German' => '262152',
	'French|Russian' => '131080',
	'German|English' => '65540',
	'German|French' => '524292',
	'German|Russian' => '131076',
	'Italian|Russian' => '131088',
	'Russian|English' => '65538',
	'Russian|French' => '524290',
	'Russian|German' => '262146',
	'Spanish|English' => '65568'
	}
};

$Teletranslator = {
NAME => 'Gist-In-Time',
PATH => 'http://www.teletranslator.com:8090/?AlisUI=none&$LANG&AlisTargetURI=$URL',
ENCODE => 0,

LANG => {
	'English|Spanish' => 'AlisSourceLang=en&AlisTargetLang=es',
	'English|French' => 'AlisSourceLang=en&AlisTargetLang=fr',
	'English|German' => 'AlisSourceLang=en&AlisTargetLang=de',
	'English|Italian' => 'AlisSourceLang=en&AlisTargetLang=it',
	'English|Japanese' => 'AlisSourceLang=en&AlisTargetLang=ja',
	'English|Portuguese' => 'AlisSourceLang=en&AlisTargetLang=pt',
	'English|Chinese Simplified' => 'AlisSourceLang=en&AlisTargetLang=zh-cn',
	'English|Chinese Traditional' => 'AlisSourceLang=en&AlisTargetLang=zh-tw',
	'Spanish|English' => 'AlisSourceLang=es&AlisTargetLang=en',
	'French|English' => 'AlisSourceLang=fr&AlisTargetLang=en',
	'French|German' => 'AlisSourceLang=fr&AlisTargetLang=de',
	'French|Russian' => 'AlisSourceLang=fr&AlisTargetLang=ru',
	'German|English' => 'AlisSourceLang=de&AlisTargetLang=en',
	'German|French' => 'AlisSourceLang=de&AlisTargetLang=fr',
	'Italian|English' => 'AlisSourceLang=it&AlisTargetLang=en',
	'Japanese|English' => 'AlisSourceLang=ja&AlisTargetLang=en',
	'Portuguese|English' => 'AlisSourceLang=pt&AlisTargetLang=en',
	'Russian|French' => 'AlisSourceLang=ru&AlisTargetLang=fr'
	}
};

$Systran = {
NAME => 'SysTran',
PATH => 'http://www.systranlinks.com/systran/cgi?lp=$LANG&partner=demo-SystranSoft&f=32&urltext=$URL',
ENCODE => 0,

LANG => {
	'English|French' => 'en_fr',
	'English|German' => 'en_de',
	'English|Italian' => 'en_it',
	'English|Portuguese' => 'en_pt',
	'English|Spanish' => 'en_es',
	'French|English' => 'fr_en',
	'French|German' => 'fr_de',
	'German|English' => 'de_en',
	'German|French' => 'de_fr',
	'Italian|English' => 'it_en',
	'Spanish|English' => 'es_en',
	'Portuguese|English' => 'pt_en'
	}
};

$Babelfish = {
NAME => 'Altavista Babelfish',
PATH => 'http://babelfish.altavista.com/tr?doit=done&tt=url&url=$URL&lp=$LANG',
ENCODE => 0,

LANG => {
	'English|Chinese' => 'en_zh',
	'English|French' => 'en_fr',
	'English|German' => 'en_de',
	'English|Italian' => 'en_it',
	'English|Japanese' => 'en_ja',
	'English|Korean' => 'en_ko',
	'English|Portuguese' => 'en_pt',
	'English|Spanish' => 'en_es',
	'Chinese|English' => 'zh_en',
	'French|English' => 'fr_en',
	'French|German' => 'fr_de',
	'German|English' => 'de_en',
	'German|French' => 'de_fr',
	'Italian|English' => 'it_en',
	'Japanese|English' => 'ja_en',
	'Korean|English' => 'ko_en',
	'Portuguese|English' => 'pt_en',
	'Russian|English' => 'ru_en',
	'Spanish|English' => 'es_en'
	}
};

$Freetranslation = {
NAME => 'FreeTranslation.com',
PATH => 'http://fets3.freetranslation.com:5081/?Sequence=core&Language=$LANG&Url=$URL',
ENCODE => 0,

LANG => {
	'Spanish|English' => 'Spanish/English',
	'French|English' => 'French/English',
	'German|English' => 'German/English',
	'Portuguese|English' => 'Portuguese/English',
	'English|Spanish' => 'English/Spanish',
	'English|French' => 'English/French',
	'English|German' => 'English/German',
	'English|Italian' => 'English/Italian',
	'English|Norwegian' => 'English/Norwegian',
	'English|Portuguese' => 'English/Portuguese'
	}
};

$Lycos = {
NAME => 'Lycos Translation',
PATH => 'http://translation.lycos.com/?lp=$LANG&f=32&urltext=$URL',
ENCODE => 0,

LANG => {
	'German|English' => 'de_en',
	'German|French' => 'de_fr',
	'English|German' => 'en_de',
	'English|Spanish' => 'en_es',
	'English|French' => 'en_fr',
	'English|Italian' => 'en_it',
	'English|Portuguese' => 'en_pt',
	'Spanish|English' => 'es_en',
	'Spanish|French' => 'es_fr',
	'French|German' => 'fr_de',
	'French|English' => 'fr_en',
	'French|Spanish' => 'fr_es',
	'French|Italian' => 'fr_it',
	'French|Dutch' => 'fr_nl',
	'French|Portuguese' => 'fr_pt',
	'Italian|English' => 'it_en',
	'Italian|French' => 'it_fr',
	'Portuguese|English' => 'pt_en'
	}
};

$Intertran = {
NAME => 'InterTran',
PATH => 'http://www.tranexp.com:2000/InterTran?$LANG&type=url&url=$URL',
ENCODE => 0,

LANG => {
	'Brazilian Portuguese|Bulgarian' => 'from=pob&to=bul',
	'Brazilian Portuguese|Croatian' => 'from=pob&to=cro',
	'Brazilian Portuguese|Czech' => 'from=pob&to=che',
	'Brazilian Portuguese|Danish' => 'from=pob&to=dan',
	'Brazilian Portuguese|Dutch' => 'from=pob&to=dut',
	'Brazilian Portuguese|English' => 'from=pob&to=eng',
	'Brazilian Portuguese|European Spanish' => 'from=pob&to=spe',
	'Brazilian Portuguese|Filipino (Tagalog)' => 'from=pob&to=tag',
	'Brazilian Portuguese|Finnish' => 'from=pob&to=fin',
	'Brazilian Portuguese|French' => 'from=pob&to=fre',
	'Brazilian Portuguese|German' => 'from=pob&to=ger',
	'Brazilian Portuguese|Greek' => 'from=pob&to=grk',
	'Brazilian Portuguese|Hungarian' => 'from=pob&to=hun',
	'Brazilian Portuguese|Icelandic' => 'from=pob&to=ice',
	'Brazilian Portuguese|Italian' => 'from=pob&to=ita',
	'Brazilian Portuguese|Japanese' => 'from=pob&to=jpn',
	'Brazilian Portuguese|Latin American Spanish' => 'from=pob&to=spl',
	'Brazilian Portuguese|Norwegian' => 'from=pob&to=nor',
	'Brazilian Portuguese|Polish' => 'from=pob&to=pol',
	'Brazilian Portuguese|Portuguese' => 'from=pob&to=poe',
	'Brazilian Portuguese|Romanian' => 'from=pob&to=rom',
	'Brazilian Portuguese|Russian' => 'from=pob&to=rus',
	'Brazilian Portuguese|Serbian' => 'from=pob&to=sel',
	'Brazilian Portuguese|Slovenian' => 'from=pob&to=slo',
	'Brazilian Portuguese|Spanish' => 'from=pob&to=spa',
	'Brazilian Portuguese|Swedish' => 'from=pob&to=swe',
	'Brazilian Portuguese|Welsh' => 'from=pob&to=wel',
	'Bulgarian|Brazilian Portuguese' => 'from=bul&to=pob',
	'Bulgarian|Croatian' => 'from=bul&to=cro',
	'Bulgarian|Czech' => 'from=bul&to=che',
	'Bulgarian|Danish' => 'from=bul&to=dan',
	'Bulgarian|Dutch' => 'from=bul&to=dut',
	'Bulgarian|English' => 'from=bul&to=eng',
	'Bulgarian|European Spanish' => 'from=bul&to=spe',
	'Bulgarian|Filipino (Tagalog)' => 'from=bul&to=tag',
	'Bulgarian|Finnish' => 'from=bul&to=fin',
	'Bulgarian|French' => 'from=bul&to=fre',
	'Bulgarian|German' => 'from=bul&to=ger',
	'Bulgarian|Greek' => 'from=bul&to=grk',
	'Bulgarian|Hungarian' => 'from=bul&to=hun',
	'Bulgarian|Icelandic' => 'from=bul&to=ice',
	'Bulgarian|Italian' => 'from=bul&to=ita',
	'Bulgarian|Japanese' => 'from=bul&to=jpn',
	'Bulgarian|Latin American Spanish' => 'from=bul&to=spl',
	'Bulgarian|Norwegian' => 'from=bul&to=nor',
	'Bulgarian|Polish' => 'from=bul&to=pol',
	'Bulgarian|Portuguese' => 'from=bul&to=poe',
	'Bulgarian|Romanian' => 'from=bul&to=rom',
	'Bulgarian|Russian' => 'from=bul&to=rus',
	'Bulgarian|Serbian' => 'from=bul&to=sel',
	'Bulgarian|Slovenian' => 'from=bul&to=slo',
	'Bulgarian|Spanish' => 'from=bul&to=spa',
	'Bulgarian|Swedish' => 'from=bul&to=swe',
	'Bulgarian|Welsh' => 'from=bul&to=wel',
	'Croatian|Brazilian Portuguese' => 'from=cro&to=pob',
	'Croatian|Bulgarian' => 'from=cro&to=bul',
	'Croatian|Czech' => 'from=cro&to=che',
	'Croatian|Danish' => 'from=cro&to=dan',
	'Croatian|Dutch' => 'from=cro&to=dut',
	'Croatian|English' => 'from=cro&to=eng',
	'Croatian|European Spanish' => 'from=cro&to=spe',
	'Croatian|Filipino (Tagalog)' => 'from=cro&to=tag',
	'Croatian|Finnish' => 'from=cro&to=fin',
	'Croatian|French' => 'from=cro&to=fre',
	'Croatian|German' => 'from=cro&to=ger',
	'Croatian|Greek' => 'from=cro&to=grk',
	'Croatian|Hungarian' => 'from=cro&to=hun',
	'Croatian|Icelandic' => 'from=cro&to=ice',
	'Croatian|Italian' => 'from=cro&to=ita',
	'Croatian|Japanese' => 'from=cro&to=jpn',
	'Croatian|Latin American Spanish' => 'from=cro&to=spl',
	'Croatian|Norwegian' => 'from=cro&to=nor',
	'Croatian|Polish' => 'from=cro&to=pol',
	'Croatian|Portuguese' => 'from=cro&to=poe',
	'Croatian|Romanian' => 'from=cro&to=rom',
	'Croatian|Russian' => 'from=cro&to=rus',
	'Croatian|Serbian' => 'from=cro&to=sel',
	'Croatian|Slovenian' => 'from=cro&to=slo',
	'Croatian|Spanish' => 'from=cro&to=spa',
	'Croatian|Swedish' => 'from=cro&to=swe',
	'Croatian|Welsh' => 'from=cro&to=wel',
	'Czech|Brazilian Portuguese' => 'from=che&to=pob',
	'Czech|Bulgarian' => 'from=che&to=bul',
	'Czech|Croatian' => 'from=che&to=cro',
	'Czech|Danish' => 'from=che&to=dan',
	'Czech|Dutch' => 'from=che&to=dut',
	'Czech|English' => 'from=che&to=eng',
	'Czech|European Spanish' => 'from=che&to=spe',
	'Czech|Filipino (Tagalog)' => 'from=che&to=tag',
	'Czech|Finnish' => 'from=che&to=fin',
	'Czech|French' => 'from=che&to=fre',
	'Czech|German' => 'from=che&to=ger',
	'Czech|Greek' => 'from=che&to=grk',
	'Czech|Hungarian' => 'from=che&to=hun',
	'Czech|Icelandic' => 'from=che&to=ice',
	'Czech|Italian' => 'from=che&to=ita',
	'Czech|Japanese' => 'from=che&to=jpn',
	'Czech|Latin American Spanish' => 'from=che&to=spl',
	'Czech|Norwegian' => 'from=che&to=nor',
	'Czech|Polish' => 'from=che&to=pol',
	'Czech|Portuguese' => 'from=che&to=poe',
	'Czech|Romanian' => 'from=che&to=rom',
	'Czech|Russian' => 'from=che&to=rus',
	'Czech|Serbian' => 'from=che&to=sel',
	'Czech|Slovenian' => 'from=che&to=slo',
	'Czech|Spanish' => 'from=che&to=spa',
	'Czech|Swedish' => 'from=che&to=swe',
	'Czech|Welsh' => 'from=che&to=wel',
	'Danish|Brazilian Portuguese' => 'from=dan&to=pob',
	'Danish|Bulgarian' => 'from=dan&to=bul',
	'Danish|Croatian' => 'from=dan&to=cro',
	'Danish|Czech' => 'from=dan&to=che',
	'Danish|Dutch' => 'from=dan&to=dut',
	'Danish|English' => 'from=dan&to=eng',
	'Danish|European Spanish' => 'from=dan&to=spe',
	'Danish|Filipino (Tagalog)' => 'from=dan&to=tag',
	'Danish|Finnish' => 'from=dan&to=fin',
	'Danish|French' => 'from=dan&to=fre',
	'Danish|German' => 'from=dan&to=ger',
	'Danish|Greek' => 'from=dan&to=grk',
	'Danish|Hungarian' => 'from=dan&to=hun',
	'Danish|Icelandic' => 'from=dan&to=ice',
	'Danish|Italian' => 'from=dan&to=ita',
	'Danish|Japanese' => 'from=dan&to=jpn',
	'Danish|Latin American Spanish' => 'from=dan&to=spl',
	'Danish|Norwegian' => 'from=dan&to=nor',
	'Danish|Polish' => 'from=dan&to=pol',
	'Danish|Portuguese' => 'from=dan&to=poe',
	'Danish|Romanian' => 'from=dan&to=rom',
	'Danish|Russian' => 'from=dan&to=rus',
	'Danish|Serbian' => 'from=dan&to=sel',
	'Danish|Slovenian' => 'from=dan&to=slo',
	'Danish|Spanish' => 'from=dan&to=spa',
	'Danish|Swedish' => 'from=dan&to=swe',
	'Danish|Welsh' => 'from=dan&to=wel',
	'Dutch|Brazilian Portuguese' => 'from=dut&to=pob',
	'Dutch|Bulgarian' => 'from=dut&to=bul',
	'Dutch|Croatian' => 'from=dut&to=cro',
	'Dutch|Czech' => 'from=dut&to=che',
	'Dutch|Danish' => 'from=dut&to=dan',
	'Dutch|English' => 'from=dut&to=eng',
	'Dutch|European Spanish' => 'from=dut&to=spe',
	'Dutch|Filipino (Tagalog)' => 'from=dut&to=tag',
	'Dutch|Finnish' => 'from=dut&to=fin',
	'Dutch|French' => 'from=dut&to=fre',
	'Dutch|German' => 'from=dut&to=ger',
	'Dutch|Greek' => 'from=dut&to=grk',
	'Dutch|Hungarian' => 'from=dut&to=hun',
	'Dutch|Icelandic' => 'from=dut&to=ice',
	'Dutch|Italian' => 'from=dut&to=ita',
	'Dutch|Japanese' => 'from=dut&to=jpn',
	'Dutch|Latin American Spanish' => 'from=dut&to=spl',
	'Dutch|Norwegian' => 'from=dut&to=nor',
	'Dutch|Polish' => 'from=dut&to=pol',
	'Dutch|Portuguese' => 'from=dut&to=poe',
	'Dutch|Romanian' => 'from=dut&to=rom',
	'Dutch|Russian' => 'from=dut&to=rus',
	'Dutch|Serbian' => 'from=dut&to=sel',
	'Dutch|Slovenian' => 'from=dut&to=slo',
	'Dutch|Spanish' => 'from=dut&to=spa',
	'Dutch|Swedish' => 'from=dut&to=swe',
	'Dutch|Welsh' => 'from=dut&to=wel',
	'English|Brazilian Portuguese' => 'from=eng&to=pob',
	'English|Bulgarian' => 'from=eng&to=bul',
	'English|Croatian' => 'from=eng&to=cro',
	'English|Czech' => 'from=eng&to=che',
	'English|Danish' => 'from=eng&to=dan',
	'English|Dutch' => 'from=eng&to=dut',
	'English|European Spanish' => 'from=eng&to=spe',
	'English|Filipino (Tagalog)' => 'from=eng&to=tag',
	'English|Finnish' => 'from=eng&to=fin',
	'English|French' => 'from=eng&to=fre',
	'English|German' => 'from=eng&to=ger',
	'English|Greek' => 'from=eng&to=grk',
	'English|Hungarian' => 'from=eng&to=hun',
	'English|Icelandic' => 'from=eng&to=ice',
	'English|Italian' => 'from=eng&to=ita',
	'English|Japanese' => 'from=eng&to=jpn',
	'English|Latin American Spanish' => 'from=eng&to=spl',
	'English|Norwegian' => 'from=eng&to=nor',
	'English|Polish' => 'from=eng&to=pol',
	'English|Portuguese' => 'from=eng&to=poe',
	'English|Romanian' => 'from=eng&to=rom',
	'English|Russian' => 'from=eng&to=rus',
	'English|Serbian' => 'from=eng&to=sel',
	'English|Slovenian' => 'from=eng&to=slo',
	'English|Spanish' => 'from=eng&to=spa',
	'English|Swedish' => 'from=eng&to=swe',
	'English|Welsh' => 'from=eng&to=wel',
	'European Spanish|Brazilian Portuguese' => 'from=spe&to=pob',
	'European Spanish|Bulgarian' => 'from=spe&to=bul',
	'European Spanish|Croatian' => 'from=spe&to=cro',
	'European Spanish|Czech' => 'from=spe&to=che',
	'European Spanish|Danish' => 'from=spe&to=dan',
	'European Spanish|Dutch' => 'from=spe&to=dut',
	'European Spanish|English' => 'from=spe&to=eng',
	'European Spanish|Filipino (Tagalog)' => 'from=spe&to=tag',
	'European Spanish|Finnish' => 'from=spe&to=fin',
	'European Spanish|French' => 'from=spe&to=fre',
	'European Spanish|German' => 'from=spe&to=ger',
	'European Spanish|Greek' => 'from=spe&to=grk',
	'European Spanish|Hungarian' => 'from=spe&to=hun',
	'European Spanish|Icelandic' => 'from=spe&to=ice',
	'European Spanish|Italian' => 'from=spe&to=ita',
	'European Spanish|Japanese' => 'from=spe&to=jpn',
	'European Spanish|Latin American Spanish' => 'from=spe&to=spl',
	'European Spanish|Norwegian' => 'from=spe&to=nor',
	'European Spanish|Polish' => 'from=spe&to=pol',
	'European Spanish|Portuguese' => 'from=spe&to=poe',
	'European Spanish|Romanian' => 'from=spe&to=rom',
	'European Spanish|Russian' => 'from=spe&to=rus',
	'European Spanish|Serbian' => 'from=spe&to=sel',
	'European Spanish|Slovenian' => 'from=spe&to=slo',
	'European Spanish|Spanish' => 'from=spe&to=spa',
	'European Spanish|Swedish' => 'from=spe&to=swe',
	'European Spanish|Welsh' => 'from=spe&to=wel',
	'Filipino (Tagalog)|Brazilian Portuguese' => 'from=tag&to=pob',
	'Filipino (Tagalog)|Bulgarian' => 'from=tag&to=bul',
	'Filipino (Tagalog)|Croatian' => 'from=tag&to=cro',
	'Filipino (Tagalog)|Czech' => 'from=tag&to=che',
	'Filipino (Tagalog)|Danish' => 'from=tag&to=dan',
	'Filipino (Tagalog)|Dutch' => 'from=tag&to=dut',
	'Filipino (Tagalog)|English' => 'from=tag&to=eng',
	'Filipino (Tagalog)|European Spanish' => 'from=tag&to=spe',
	'Filipino (Tagalog)|Finnish' => 'from=tag&to=fin',
	'Filipino (Tagalog)|French' => 'from=tag&to=fre',
	'Filipino (Tagalog)|German' => 'from=tag&to=ger',
	'Filipino (Tagalog)|Greek' => 'from=tag&to=grk',
	'Filipino (Tagalog)|Hungarian' => 'from=tag&to=hun',
	'Filipino (Tagalog)|Icelandic' => 'from=tag&to=ice',
	'Filipino (Tagalog)|Italian' => 'from=tag&to=ita',
	'Filipino (Tagalog)|Japanese' => 'from=tag&to=jpn',
	'Filipino (Tagalog)|Latin American Spanish' => 'from=tag&to=spl',
	'Filipino (Tagalog)|Norwegian' => 'from=tag&to=nor',
	'Filipino (Tagalog)|Polish' => 'from=tag&to=pol',
	'Filipino (Tagalog)|Portuguese' => 'from=tag&to=poe',
	'Filipino (Tagalog)|Romanian' => 'from=tag&to=rom',
	'Filipino (Tagalog)|Russian' => 'from=tag&to=rus',
	'Filipino (Tagalog)|Serbian' => 'from=tag&to=sel',
	'Filipino (Tagalog)|Slovenian' => 'from=tag&to=slo',
	'Filipino (Tagalog)|Spanish' => 'from=tag&to=spa',
	'Filipino (Tagalog)|Swedish' => 'from=tag&to=swe',
	'Filipino (Tagalog)|Welsh' => 'from=tag&to=wel',
	'Finnish|Brazilian Portuguese' => 'from=fin&to=pob',
	'Finnish|Bulgarian' => 'from=fin&to=bul',
	'Finnish|Croatian' => 'from=fin&to=cro',
	'Finnish|Czech' => 'from=fin&to=che',
	'Finnish|Danish' => 'from=fin&to=dan',
	'Finnish|Dutch' => 'from=fin&to=dut',
	'Finnish|English' => 'from=fin&to=eng',
	'Finnish|European Spanish' => 'from=fin&to=spe',
	'Finnish|Filipino (Tagalog)' => 'from=fin&to=tag',
	'Finnish|French' => 'from=fin&to=fre',
	'Finnish|German' => 'from=fin&to=ger',
	'Finnish|Greek' => 'from=fin&to=grk',
	'Finnish|Hungarian' => 'from=fin&to=hun',
	'Finnish|Icelandic' => 'from=fin&to=ice',
	'Finnish|Italian' => 'from=fin&to=ita',
	'Finnish|Japanese' => 'from=fin&to=jpn',
	'Finnish|Latin American Spanish' => 'from=fin&to=spl',
	'Finnish|Norwegian' => 'from=fin&to=nor',
	'Finnish|Polish' => 'from=fin&to=pol',
	'Finnish|Portuguese' => 'from=fin&to=poe',
	'Finnish|Romanian' => 'from=fin&to=rom',
	'Finnish|Russian' => 'from=fin&to=rus',
	'Finnish|Serbian' => 'from=fin&to=sel',
	'Finnish|Slovenian' => 'from=fin&to=slo',
	'Finnish|Spanish' => 'from=fin&to=spa',
	'Finnish|Swedish' => 'from=fin&to=swe',
	'Finnish|Welsh' => 'from=fin&to=wel',
	'French|Brazilian Portuguese' => 'from=fre&to=pob',
	'French|Bulgarian' => 'from=fre&to=bul',
	'French|Croatian' => 'from=fre&to=cro',
	'French|Czech' => 'from=fre&to=che',
	'French|Danish' => 'from=fre&to=dan',
	'French|Dutch' => 'from=fre&to=dut',
	'French|English' => 'from=fre&to=eng',
	'French|European Spanish' => 'from=fre&to=spe',
	'French|Filipino (Tagalog)' => 'from=fre&to=tag',
	'French|Finnish' => 'from=fre&to=fin',
	'French|German' => 'from=fre&to=ger',
	'French|Greek' => 'from=fre&to=grk',
	'French|Hungarian' => 'from=fre&to=hun',
	'French|Icelandic' => 'from=fre&to=ice',
	'French|Italian' => 'from=fre&to=ita',
	'French|Japanese' => 'from=fre&to=jpn',
	'French|Latin American Spanish' => 'from=fre&to=spl',
	'French|Norwegian' => 'from=fre&to=nor',
	'French|Polish' => 'from=fre&to=pol',
	'French|Portuguese' => 'from=fre&to=poe',
	'French|Romanian' => 'from=fre&to=rom',
	'French|Russian' => 'from=fre&to=rus',
	'French|Serbian' => 'from=fre&to=sel',
	'French|Slovenian' => 'from=fre&to=slo',
	'French|Spanish' => 'from=fre&to=spa',
	'French|Swedish' => 'from=fre&to=swe',
	'French|Welsh' => 'from=fre&to=wel',
	'German|Brazilian Portuguese' => 'from=ger&to=pob',
	'German|Bulgarian' => 'from=ger&to=bul',
	'German|Croatian' => 'from=ger&to=cro',
	'German|Czech' => 'from=ger&to=che',
	'German|Danish' => 'from=ger&to=dan',
	'German|Dutch' => 'from=ger&to=dut',
	'German|English' => 'from=ger&to=eng',
	'German|European Spanish' => 'from=ger&to=spe',
	'German|Filipino (Tagalog)' => 'from=ger&to=tag',
	'German|Finnish' => 'from=ger&to=fin',
	'German|French' => 'from=ger&to=fre',
	'German|Greek' => 'from=ger&to=grk',
	'German|Hungarian' => 'from=ger&to=hun',
	'German|Icelandic' => 'from=ger&to=ice',
	'German|Italian' => 'from=ger&to=ita',
	'German|Japanese' => 'from=ger&to=jpn',
	'German|Latin American Spanish' => 'from=ger&to=spl',
	'German|Norwegian' => 'from=ger&to=nor',
	'German|Polish' => 'from=ger&to=pol',
	'German|Portuguese' => 'from=ger&to=poe',
	'German|Romanian' => 'from=ger&to=rom',
	'German|Russian' => 'from=ger&to=rus',
	'German|Serbian' => 'from=ger&to=sel',
	'German|Slovenian' => 'from=ger&to=slo',
	'German|Spanish' => 'from=ger&to=spa',
	'German|Swedish' => 'from=ger&to=swe',
	'German|Welsh' => 'from=ger&to=wel',
	'Greek|Brazilian Portuguese' => 'from=grk&to=pob',
	'Greek|Bulgarian' => 'from=grk&to=bul',
	'Greek|Croatian' => 'from=grk&to=cro',
	'Greek|Czech' => 'from=grk&to=che',
	'Greek|Danish' => 'from=grk&to=dan',
	'Greek|Dutch' => 'from=grk&to=dut',
	'Greek|English' => 'from=grk&to=eng',
	'Greek|European Spanish' => 'from=grk&to=spe',
	'Greek|Filipino (Tagalog)' => 'from=grk&to=tag',
	'Greek|Finnish' => 'from=grk&to=fin',
	'Greek|French' => 'from=grk&to=fre',
	'Greek|German' => 'from=grk&to=ger',
	'Greek|Hungarian' => 'from=grk&to=hun',
	'Greek|Icelandic' => 'from=grk&to=ice',
	'Greek|Italian' => 'from=grk&to=ita',
	'Greek|Japanese' => 'from=grk&to=jpn',
	'Greek|Latin American Spanish' => 'from=grk&to=spl',
	'Greek|Norwegian' => 'from=grk&to=nor',
	'Greek|Polish' => 'from=grk&to=pol',
	'Greek|Portuguese' => 'from=grk&to=poe',
	'Greek|Romanian' => 'from=grk&to=rom',
	'Greek|Russian' => 'from=grk&to=rus',
	'Greek|Serbian' => 'from=grk&to=sel',
	'Greek|Slovenian' => 'from=grk&to=slo',
	'Greek|Spanish' => 'from=grk&to=spa',
	'Greek|Swedish' => 'from=grk&to=swe',
	'Greek|Welsh' => 'from=grk&to=wel',
	'Hungarian|Brazilian Portuguese' => 'from=hun&to=pob',
	'Hungarian|Bulgarian' => 'from=hun&to=bul',
	'Hungarian|Croatian' => 'from=hun&to=cro',
	'Hungarian|Czech' => 'from=hun&to=che',
	'Hungarian|Danish' => 'from=hun&to=dan',
	'Hungarian|Dutch' => 'from=hun&to=dut',
	'Hungarian|English' => 'from=hun&to=eng',
	'Hungarian|European Spanish' => 'from=hun&to=spe',
	'Hungarian|Filipino (Tagalog)' => 'from=hun&to=tag',
	'Hungarian|Finnish' => 'from=hun&to=fin',
	'Hungarian|French' => 'from=hun&to=fre',
	'Hungarian|German' => 'from=hun&to=ger',
	'Hungarian|Greek' => 'from=hun&to=grk',
	'Hungarian|Icelandic' => 'from=hun&to=ice',
	'Hungarian|Italian' => 'from=hun&to=ita',
	'Hungarian|Japanese' => 'from=hun&to=jpn',
	'Hungarian|Latin American Spanish' => 'from=hun&to=spl',
	'Hungarian|Norwegian' => 'from=hun&to=nor',
	'Hungarian|Polish' => 'from=hun&to=pol',
	'Hungarian|Portuguese' => 'from=hun&to=poe',
	'Hungarian|Romanian' => 'from=hun&to=rom',
	'Hungarian|Russian' => 'from=hun&to=rus',
	'Hungarian|Serbian' => 'from=hun&to=sel',
	'Hungarian|Slovenian' => 'from=hun&to=slo',
	'Hungarian|Spanish' => 'from=hun&to=spa',
	'Hungarian|Swedish' => 'from=hun&to=swe',
	'Hungarian|Welsh' => 'from=hun&to=wel',
	'Icelandic|Brazilian Portuguese' => 'from=ice&to=pob',
	'Icelandic|Bulgarian' => 'from=ice&to=bul',
	'Icelandic|Croatian' => 'from=ice&to=cro',
	'Icelandic|Czech' => 'from=ice&to=che',
	'Icelandic|Danish' => 'from=ice&to=dan',
	'Icelandic|Dutch' => 'from=ice&to=dut',
	'Icelandic|English' => 'from=ice&to=eng',
	'Icelandic|European Spanish' => 'from=ice&to=spe',
	'Icelandic|Filipino (Tagalog)' => 'from=ice&to=tag',
	'Icelandic|Finnish' => 'from=ice&to=fin',
	'Icelandic|French' => 'from=ice&to=fre',
	'Icelandic|German' => 'from=ice&to=ger',
	'Icelandic|Greek' => 'from=ice&to=grk',
	'Icelandic|Hungarian' => 'from=ice&to=hun',
	'Icelandic|Italian' => 'from=ice&to=ita',
	'Icelandic|Japanese' => 'from=ice&to=jpn',
	'Icelandic|Latin American Spanish' => 'from=ice&to=spl',
	'Icelandic|Norwegian' => 'from=ice&to=nor',
	'Icelandic|Polish' => 'from=ice&to=pol',
	'Icelandic|Portuguese' => 'from=ice&to=poe',
	'Icelandic|Romanian' => 'from=ice&to=rom',
	'Icelandic|Russian' => 'from=ice&to=rus',
	'Icelandic|Serbian' => 'from=ice&to=sel',
	'Icelandic|Slovenian' => 'from=ice&to=slo',
	'Icelandic|Spanish' => 'from=ice&to=spa',
	'Icelandic|Swedish' => 'from=ice&to=swe',
	'Icelandic|Welsh' => 'from=ice&to=wel',
	'Italian|Brazilian Portuguese' => 'from=ita&to=pob',
	'Italian|Bulgarian' => 'from=ita&to=bul',
	'Italian|Croatian' => 'from=ita&to=cro',
	'Italian|Czech' => 'from=ita&to=che',
	'Italian|Danish' => 'from=ita&to=dan',
	'Italian|Dutch' => 'from=ita&to=dut',
	'Italian|English' => 'from=ita&to=eng',
	'Italian|European Spanish' => 'from=ita&to=spe',
	'Italian|Filipino (Tagalog)' => 'from=ita&to=tag',
	'Italian|Finnish' => 'from=ita&to=fin',
	'Italian|French' => 'from=ita&to=fre',
	'Italian|German' => 'from=ita&to=ger',
	'Italian|Greek' => 'from=ita&to=grk',
	'Italian|Hungarian' => 'from=ita&to=hun',
	'Italian|Icelandic' => 'from=ita&to=ice',
	'Italian|Japanese' => 'from=ita&to=jpn',
	'Italian|Latin American Spanish' => 'from=ita&to=spl',
	'Italian|Norwegian' => 'from=ita&to=nor',
	'Italian|Polish' => 'from=ita&to=pol',
	'Italian|Portuguese' => 'from=ita&to=poe',
	'Italian|Romanian' => 'from=ita&to=rom',
	'Italian|Russian' => 'from=ita&to=rus',
	'Italian|Serbian' => 'from=ita&to=sel',
	'Italian|Slovenian' => 'from=ita&to=slo',
	'Italian|Spanish' => 'from=ita&to=spa',
	'Italian|Swedish' => 'from=ita&to=swe',
	'Italian|Welsh' => 'from=ita&to=wel',
	'Japanese|Brazilian Portuguese' => 'from=jpn&to=pob',
	'Japanese|Bulgarian' => 'from=jpn&to=bul',
	'Japanese|Croatian' => 'from=jpn&to=cro',
	'Japanese|Czech' => 'from=jpn&to=che',
	'Japanese|Danish' => 'from=jpn&to=dan',
	'Japanese|Dutch' => 'from=jpn&to=dut',
	'Japanese|English' => 'from=jpn&to=eng',
	'Japanese|European Spanish' => 'from=jpn&to=spe',
	'Japanese|Filipino (Tagalog)' => 'from=jpn&to=tag',
	'Japanese|Finnish' => 'from=jpn&to=fin',
	'Japanese|French' => 'from=jpn&to=fre',
	'Japanese|German' => 'from=jpn&to=ger',
	'Japanese|Greek' => 'from=jpn&to=grk',
	'Japanese|Hungarian' => 'from=jpn&to=hun',
	'Japanese|Icelandic' => 'from=jpn&to=ice',
	'Japanese|Italian' => 'from=jpn&to=ita',
	'Japanese|Latin American Spanish' => 'from=jpn&to=spl',
	'Japanese|Norwegian' => 'from=jpn&to=nor',
	'Japanese|Polish' => 'from=jpn&to=pol',
	'Japanese|Portuguese' => 'from=jpn&to=poe',
	'Japanese|Romanian' => 'from=jpn&to=rom',
	'Japanese|Russian' => 'from=jpn&to=rus',
	'Japanese|Serbian' => 'from=jpn&to=sel',
	'Japanese|Slovenian' => 'from=jpn&to=slo',
	'Japanese|Spanish' => 'from=jpn&to=spa',
	'Japanese|Swedish' => 'from=jpn&to=swe',
	'Japanese|Welsh' => 'from=jpn&to=wel',
	'Latin American Spanish|Brazilian Portuguese' => 'from=spl&to=pob',
	'Latin American Spanish|Bulgarian' => 'from=spl&to=bul',
	'Latin American Spanish|Croatian' => 'from=spl&to=cro',
	'Latin American Spanish|Czech' => 'from=spl&to=che',
	'Latin American Spanish|Danish' => 'from=spl&to=dan',
	'Latin American Spanish|Dutch' => 'from=spl&to=dut',
	'Latin American Spanish|English' => 'from=spl&to=eng',
	'Latin American Spanish|European Spanish' => 'from=spl&to=spe',
	'Latin American Spanish|Filipino (Tagalog)' => 'from=spl&to=tag',
	'Latin American Spanish|Finnish' => 'from=spl&to=fin',
	'Latin American Spanish|French' => 'from=spl&to=fre',
	'Latin American Spanish|German' => 'from=spl&to=ger',
	'Latin American Spanish|Greek' => 'from=spl&to=grk',
	'Latin American Spanish|Hungarian' => 'from=spl&to=hun',
	'Latin American Spanish|Icelandic' => 'from=spl&to=ice',
	'Latin American Spanish|Italian' => 'from=spl&to=ita',
	'Latin American Spanish|Japanese' => 'from=spl&to=jpn',
	'Latin American Spanish|Norwegian' => 'from=spl&to=nor',
	'Latin American Spanish|Polish' => 'from=spl&to=pol',
	'Latin American Spanish|Portuguese' => 'from=spl&to=poe',
	'Latin American Spanish|Romanian' => 'from=spl&to=rom',
	'Latin American Spanish|Russian' => 'from=spl&to=rus',
	'Latin American Spanish|Serbian' => 'from=spl&to=sel',
	'Latin American Spanish|Slovenian' => 'from=spl&to=slo',
	'Latin American Spanish|Spanish' => 'from=spl&to=spa',
	'Latin American Spanish|Swedish' => 'from=spl&to=swe',
	'Latin American Spanish|Welsh' => 'from=spl&to=wel',
	'Norwegian|Brazilian Portuguese' => 'from=nor&to=pob',
	'Norwegian|Bulgarian' => 'from=nor&to=bul',
	'Norwegian|Croatian' => 'from=nor&to=cro',
	'Norwegian|Czech' => 'from=nor&to=che',
	'Norwegian|Danish' => 'from=nor&to=dan',
	'Norwegian|Dutch' => 'from=nor&to=dut',
	'Norwegian|English' => 'from=nor&to=eng',
	'Norwegian|European Spanish' => 'from=nor&to=spe',
	'Norwegian|Filipino (Tagalog)' => 'from=nor&to=tag',
	'Norwegian|Finnish' => 'from=nor&to=fin',
	'Norwegian|French' => 'from=nor&to=fre',
	'Norwegian|German' => 'from=nor&to=ger',
	'Norwegian|Greek' => 'from=nor&to=grk',
	'Norwegian|Hungarian' => 'from=nor&to=hun',
	'Norwegian|Icelandic' => 'from=nor&to=ice',
	'Norwegian|Italian' => 'from=nor&to=ita',
	'Norwegian|Japanese' => 'from=nor&to=jpn',
	'Norwegian|Latin American Spanish' => 'from=nor&to=spl',
	'Norwegian|Polish' => 'from=nor&to=pol',
	'Norwegian|Portuguese' => 'from=nor&to=poe',
	'Norwegian|Romanian' => 'from=nor&to=rom',
	'Norwegian|Russian' => 'from=nor&to=rus',
	'Norwegian|Serbian' => 'from=nor&to=sel',
	'Norwegian|Slovenian' => 'from=nor&to=slo',
	'Norwegian|Spanish' => 'from=nor&to=spa',
	'Norwegian|Swedish' => 'from=nor&to=swe',
	'Norwegian|Welsh' => 'from=nor&to=wel',
	'Polish|Brazilian Portuguese' => 'from=pol&to=pob',
	'Polish|Bulgarian' => 'from=pol&to=bul',
	'Polish|Croatian' => 'from=pol&to=cro',
	'Polish|Czech' => 'from=pol&to=che',
	'Polish|Danish' => 'from=pol&to=dan',
	'Polish|Dutch' => 'from=pol&to=dut',
	'Polish|English' => 'from=pol&to=eng',
	'Polish|European Spanish' => 'from=pol&to=spe',
	'Polish|Filipino (Tagalog)' => 'from=pol&to=tag',
	'Polish|Finnish' => 'from=pol&to=fin',
	'Polish|French' => 'from=pol&to=fre',
	'Polish|German' => 'from=pol&to=ger',
	'Polish|Greek' => 'from=pol&to=grk',
	'Polish|Hungarian' => 'from=pol&to=hun',
	'Polish|Icelandic' => 'from=pol&to=ice',
	'Polish|Italian' => 'from=pol&to=ita',
	'Polish|Japanese' => 'from=pol&to=jpn',
	'Polish|Latin American Spanish' => 'from=pol&to=spl',
	'Polish|Norwegian' => 'from=pol&to=nor',
	'Polish|Portuguese' => 'from=pol&to=poe',
	'Polish|Romanian' => 'from=pol&to=rom',
	'Polish|Russian' => 'from=pol&to=rus',
	'Polish|Serbian' => 'from=pol&to=sel',
	'Polish|Slovenian' => 'from=pol&to=slo',
	'Polish|Spanish' => 'from=pol&to=spa',
	'Polish|Swedish' => 'from=pol&to=swe',
	'Polish|Welsh' => 'from=pol&to=wel',
	'Portuguese|Brazilian Portuguese' => 'from=poe&to=pob',
	'Portuguese|Bulgarian' => 'from=poe&to=bul',
	'Portuguese|Croatian' => 'from=poe&to=cro',
	'Portuguese|Czech' => 'from=poe&to=che',
	'Portuguese|Danish' => 'from=poe&to=dan',
	'Portuguese|Dutch' => 'from=poe&to=dut',
	'Portuguese|English' => 'from=poe&to=eng',
	'Portuguese|European Spanish' => 'from=poe&to=spe',
	'Portuguese|Filipino (Tagalog)' => 'from=poe&to=tag',
	'Portuguese|Finnish' => 'from=poe&to=fin',
	'Portuguese|French' => 'from=poe&to=fre',
	'Portuguese|German' => 'from=poe&to=ger',
	'Portuguese|Greek' => 'from=poe&to=grk',
	'Portuguese|Hungarian' => 'from=poe&to=hun',
	'Portuguese|Icelandic' => 'from=poe&to=ice',
	'Portuguese|Italian' => 'from=poe&to=ita',
	'Portuguese|Japanese' => 'from=poe&to=jpn',
	'Portuguese|Latin American Spanish' => 'from=poe&to=spl',
	'Portuguese|Norwegian' => 'from=poe&to=nor',
	'Portuguese|Polish' => 'from=poe&to=pol',
	'Portuguese|Romanian' => 'from=poe&to=rom',
	'Portuguese|Russian' => 'from=poe&to=rus',
	'Portuguese|Serbian' => 'from=poe&to=sel',
	'Portuguese|Slovenian' => 'from=poe&to=slo',
	'Portuguese|Spanish' => 'from=poe&to=spa',
	'Portuguese|Swedish' => 'from=poe&to=swe',
	'Portuguese|Welsh' => 'from=poe&to=wel',
	'Portuguese|Brazilian Portuguese' => 'from=rom&to=pob',
	'Portuguese|Bulgarian' => 'from=rom&to=bul',
	'Portuguese|Croatian' => 'from=rom&to=cro',
	'Portuguese|Czech' => 'from=rom&to=che',
	'Portuguese|Danish' => 'from=rom&to=dan',
	'Portuguese|Dutch' => 'from=rom&to=dut',
	'Portuguese|English' => 'from=rom&to=eng',
	'Portuguese|European Spanish' => 'from=rom&to=spe',
	'Portuguese|Filipino (Tagalog)' => 'from=rom&to=tag',
	'Portuguese|Finnish' => 'from=rom&to=fin',
	'Portuguese|French' => 'from=rom&to=fre',
	'Portuguese|German' => 'from=rom&to=ger',
	'Portuguese|Greek' => 'from=rom&to=grk',
	'Portuguese|Hungarian' => 'from=rom&to=hun',
	'Portuguese|Icelandic' => 'from=rom&to=ice',
	'Portuguese|Italian' => 'from=rom&to=ita',
	'Portuguese|Japanese' => 'from=rom&to=jpn',
	'Portuguese|Latin American Spanish' => 'from=rom&to=spl',
	'Portuguese|Norwegian' => 'from=rom&to=nor',
	'Portuguese|Polish' => 'from=rom&to=pol',
	'Portuguese|Portuguese' => 'from=rom&to=poe',
	'Portuguese|Russian' => 'from=rom&to=rus',
	'Portuguese|Serbian' => 'from=rom&to=sel',
	'Portuguese|Slovenian' => 'from=rom&to=slo',
	'Portuguese|Spanish' => 'from=rom&to=spa',
	'Portuguese|Swedish' => 'from=rom&to=swe',
	'Portuguese|Welsh' => 'from=rom&to=wel',
	'Russian|Brazilian Portuguese' => 'from=rus&to=pob',
	'Russian|Bulgarian' => 'from=rus&to=bul',
	'Russian|Croatian' => 'from=rus&to=cro',
	'Russian|Czech' => 'from=rus&to=che',
	'Russian|Danish' => 'from=rus&to=dan',
	'Russian|Dutch' => 'from=rus&to=dut',
	'Russian|English' => 'from=rus&to=eng',
	'Russian|European Spanish' => 'from=rus&to=spe',
	'Russian|Filipino (Tagalog)' => 'from=rus&to=tag',
	'Russian|Finnish' => 'from=rus&to=fin',
	'Russian|French' => 'from=rus&to=fre',
	'Russian|German' => 'from=rus&to=ger',
	'Russian|Greek' => 'from=rus&to=grk',
	'Russian|Hungarian' => 'from=rus&to=hun',
	'Russian|Icelandic' => 'from=rus&to=ice',
	'Russian|Italian' => 'from=rus&to=ita',
	'Russian|Japanese' => 'from=rus&to=jpn',
	'Russian|Latin American Spanish' => 'from=rus&to=spl',
	'Russian|Norwegian' => 'from=rus&to=nor',
	'Russian|Polish' => 'from=rus&to=pol',
	'Russian|Portuguese' => 'from=rus&to=poe',
	'Russian|Romanian' => 'from=rus&to=rom',
	'Russian|Serbian' => 'from=rus&to=sel',
	'Russian|Slovenian' => 'from=rus&to=slo',
	'Russian|Spanish' => 'from=rus&to=spa',
	'Russian|Swedish' => 'from=rus&to=swe',
	'Russian|Welsh' => 'from=rus&to=wel',
	'Serbian|Brazilian Portuguese' => 'from=sel&to=pob',
	'Serbian|Bulgarian' => 'from=sel&to=bul',
	'Serbian|Croatian' => 'from=sel&to=cro',
	'Serbian|Czech' => 'from=sel&to=che',
	'Serbian|Danish' => 'from=sel&to=dan',
	'Serbian|Dutch' => 'from=sel&to=dut',
	'Serbian|English' => 'from=sel&to=eng',
	'Serbian|European Spanish' => 'from=sel&to=spe',
	'Serbian|Filipino (Tagalog)' => 'from=sel&to=tag',
	'Serbian|Finnish' => 'from=sel&to=fin',
	'Serbian|French' => 'from=sel&to=fre',
	'Serbian|German' => 'from=sel&to=ger',
	'Serbian|Greek' => 'from=sel&to=grk',
	'Serbian|Hungarian' => 'from=sel&to=hun',
	'Serbian|Icelandic' => 'from=sel&to=ice',
	'Serbian|Italian' => 'from=sel&to=ita',
	'Serbian|Japanese' => 'from=sel&to=jpn',
	'Serbian|Latin American Spanish' => 'from=sel&to=spl',
	'Serbian|Norwegian' => 'from=sel&to=nor',
	'Serbian|Polish' => 'from=sel&to=pol',
	'Serbian|Portuguese' => 'from=sel&to=poe',
	'Serbian|Romanian' => 'from=sel&to=rom',
	'Serbian|Russian' => 'from=sel&to=rus',
	'Serbian|Slovenian' => 'from=sel&to=slo',
	'Serbian|Spanish' => 'from=sel&to=spa',
	'Serbian|Swedish' => 'from=sel&to=swe',
	'Serbian|Welsh' => 'from=sel&to=wel',
	'Slovenian|Brazilian Portuguese' => 'from=slo&to=pob',
	'Slovenian|Bulgarian' => 'from=slo&to=bul',
	'Slovenian|Croatian' => 'from=slo&to=cro',
	'Slovenian|Czech' => 'from=slo&to=che',
	'Slovenian|Danish' => 'from=slo&to=dan',
	'Slovenian|Dutch' => 'from=slo&to=dut',
	'Slovenian|English' => 'from=slo&to=eng',
	'Slovenian|European Spanish' => 'from=slo&to=spe',
	'Slovenian|Filipino (Tagalog)' => 'from=slo&to=tag',
	'Slovenian|Finnish' => 'from=slo&to=fin',
	'Slovenian|French' => 'from=slo&to=fre',
	'Slovenian|German' => 'from=slo&to=ger',
	'Slovenian|Greek' => 'from=slo&to=grk',
	'Slovenian|Hungarian' => 'from=slo&to=hun',
	'Slovenian|Icelandic' => 'from=slo&to=ice',
	'Slovenian|Italian' => 'from=slo&to=ita',
	'Slovenian|Japanese' => 'from=slo&to=jpn',
	'Slovenian|Latin American Spanish' => 'from=slo&to=spl',
	'Slovenian|Norwegian' => 'from=slo&to=nor',
	'Slovenian|Polish' => 'from=slo&to=pol',
	'Slovenian|Portuguese' => 'from=slo&to=poe',
	'Slovenian|Romanian' => 'from=slo&to=rom',
	'Slovenian|Russian' => 'from=slo&to=rus',
	'Slovenian|Serbian' => 'from=slo&to=sel',
	'Slovenian|Spanish' => 'from=slo&to=spa',
	'Slovenian|Swedish' => 'from=slo&to=swe',
	'Slovenian|Welsh' => 'from=slo&to=wel',
	'Slovenian|Brazilian Portuguese' => 'from=spa&to=pob',
	'Slovenian|Bulgarian' => 'from=spa&to=bul',
	'Slovenian|Croatian' => 'from=spa&to=cro',
	'Slovenian|Czech' => 'from=spa&to=che',
	'Slovenian|Danish' => 'from=spa&to=dan',
	'Slovenian|Dutch' => 'from=spa&to=dut',
	'Slovenian|English' => 'from=spa&to=eng',
	'Slovenian|European Spanish' => 'from=spa&to=spe',
	'Slovenian|Filipino (Tagalog)' => 'from=spa&to=tag',
	'Slovenian|Finnish' => 'from=spa&to=fin',
	'Slovenian|French' => 'from=spa&to=fre',
	'Slovenian|German' => 'from=spa&to=ger',
	'Slovenian|Greek' => 'from=spa&to=grk',
	'Slovenian|Hungarian' => 'from=spa&to=hun',
	'Slovenian|Icelandic' => 'from=spa&to=ice',
	'Slovenian|Italian' => 'from=spa&to=ita',
	'Slovenian|Japanese' => 'from=spa&to=jpn',
	'Slovenian|Latin American Spanish' => 'from=spa&to=spl',
	'Slovenian|Norwegian' => 'from=spa&to=nor',
	'Slovenian|Polish' => 'from=spa&to=pol',
	'Slovenian|Portuguese' => 'from=spa&to=poe',
	'Slovenian|Romanian' => 'from=spa&to=rom',
	'Slovenian|Russian' => 'from=spa&to=rus',
	'Slovenian|Serbian' => 'from=spa&to=sel',
	'Slovenian|Slovenian' => 'from=spa&to=slo',
	'Slovenian|Swedish' => 'from=spa&to=swe',
	'Slovenian|Welsh' => 'from=spa&to=wel',
	'Swedish|Brazilian Portuguese' => 'from=swe&to=pob',
	'Swedish|Bulgarian' => 'from=swe&to=bul',
	'Swedish|Croatian' => 'from=swe&to=cro',
	'Swedish|Czech' => 'from=swe&to=che',
	'Swedish|Danish' => 'from=swe&to=dan',
	'Swedish|Dutch' => 'from=swe&to=dut',
	'Swedish|English' => 'from=swe&to=eng',
	'Swedish|European Spanish' => 'from=swe&to=spe',
	'Swedish|Filipino (Tagalog)' => 'from=swe&to=tag',
	'Swedish|Finnish' => 'from=swe&to=fin',
	'Swedish|French' => 'from=swe&to=fre',
	'Swedish|German' => 'from=swe&to=ger',
	'Swedish|Greek' => 'from=swe&to=grk',
	'Swedish|Hungarian' => 'from=swe&to=hun',
	'Swedish|Icelandic' => 'from=swe&to=ice',
	'Swedish|Italian' => 'from=swe&to=ita',
	'Swedish|Japanese' => 'from=swe&to=jpn',
	'Swedish|Latin American Spanish' => 'from=swe&to=spl',
	'Swedish|Norwegian' => 'from=swe&to=nor',
	'Swedish|Polish' => 'from=swe&to=pol',
	'Swedish|Portuguese' => 'from=swe&to=poe',
	'Swedish|Romanian' => 'from=swe&to=rom',
	'Swedish|Russian' => 'from=swe&to=rus',
	'Swedish|Serbian' => 'from=swe&to=sel',
	'Swedish|Slovenian' => 'from=swe&to=slo',
	'Swedish|Spanish' => 'from=swe&to=spa',
	'Swedish|Welsh' => 'from=swe&to=wel',
	'Swedish|Brazilian Portuguese' => 'from=wel&to=pob',
	'Swedish|Bulgarian' => 'from=wel&to=bul',
	'Swedish|Croatian' => 'from=wel&to=cro',
	'Swedish|Czech' => 'from=wel&to=che',
	'Swedish|Danish' => 'from=wel&to=dan',
	'Swedish|Dutch' => 'from=wel&to=dut',
	'Swedish|English' => 'from=wel&to=eng',
	'Swedish|European Spanish' => 'from=wel&to=spe',
	'Swedish|Filipino (Tagalog)' => 'from=wel&to=tag',
	'Swedish|Finnish' => 'from=wel&to=fin',
	'Swedish|French' => 'from=wel&to=fre',
	'Swedish|German' => 'from=wel&to=ger',
	'Swedish|Greek' => 'from=wel&to=grk',
	'Swedish|Hungarian' => 'from=wel&to=hun',
	'Swedish|Icelandic' => 'from=wel&to=ice',
	'Swedish|Italian' => 'from=wel&to=ita',
	'Swedish|Japanese' => 'from=wel&to=jpn',
	'Swedish|Latin American Spanish' => 'from=wel&to=spl',
	'Swedish|Norwegian' => 'from=wel&to=nor',
	'Swedish|Polish' => 'from=wel&to=pol',
	'Swedish|Portuguese' => 'from=wel&to=poe',
	'Swedish|Romanian' => 'from=wel&to=rom',
	'Swedish|Russian' => 'from=wel&to=rus',
	'Swedish|Serbian' => 'from=wel&to=sel',
	'Swedish|Slovenian' => 'from=wel&to=slo',
	'Swedish|Spanish' => 'from=wel&to=spa',
	'Swedish|Swedish' => 'from=wel&to=swe'
	}
};

$Parsit = {
NAME => 'Parsit',
PATH => 'http://c3po.links.nectec.or.th/cgi-bin/parsitcgi.exe?inputType=html&inputUrl=$URL',
ENCODE => 0,

LANG => {
	'English|Thai' => '1'
	}
};

$Engines = {
		'gl'	=> $Google,
		'rv'	=> $Reverso,
		'aj'	=> $Ajeeb,
		'ts'	=> $Tsail,
		'wl'	=> $Worldlingo,
		'pl'	=> $Paralink,
		'tt'	=> $Teletranslator,
		'st'	=> $Systran,
		'bb'	=> $Babelfish,
#		'ft'	=> $Freetranslation,
		'ly'	=> $Lycos,
		'it'	=> $Intertran,
		'pa'	=> $Parsit
};
