#------------------------------------------------------------------------------
# TrnsLng Templates File
#------------------------------------------------------------------------------
# Template Format
#
# NAME:			Name of the template that should be displayed in the wizard
# STARTCODE:	HTML Code that will be placed at the beginning of the template
# ENCODE:		HTML code that will be placed at the end of the template
# MIDCODE:		HTML code that will be generated for each language and placed in
#					between the STARTCODE and ENDCODE
# SEPERATOR:	HTML code to be placed between the code of two languages
#
#
# The following shows the code placement for code generated using 3 languages
#		STARTCODE
#		MIDCODE SEPERATOR MIDCODE SEPERATOR MIDCODE
#		ENDCODE
#
# If you add a new template, make sure that you add a entry for that in the
# $Templates list, otherwise the template will not be shown in the wizard.

$TemplateVersion = "1.0";
$TemplateDate = "13 Oct 2001";

$Horizontal = {
	NAME			=> 'Horizontal Hyperlinks',
	SEPERATOR	=> ' | ',
	STARTCODE	=> 'Translate: ',
	MIDCODE		=> '<a href="$ScriptLocation?a=f&e=$Engine&p=$Pair&u=$PageURL">$TargetLanguage</a>',
	ENDCODE		=> ''
};

$Vertical = {
	NAME			=> 'Vertical Hyperlinks',
	SEPERATOR	=> '<br>',
	STARTCODE	=> '',
	MIDCODE		=> '<a href="$ScriptLocation?a=f&e=$Engine&p=$Pair&u=$PageURL">$TargetLanguage</a>',
	ENDCODE		=> ''
};

$HorizontalTable = {
	NAME			=> 'Horizontal Table',
	SEPERATOR	=> '',
	STARTCODE	=> '<table border="1" cellspacing="0" bordercolor="#000000" bgcolor="#C0C0C0" cellpadding="4" align="center">' .
						'<tr>',
	MIDCODE		=> '<td><a href="$ScriptLocation?a=f&e=$Engine&p=$Pair&u=$PageURL">$TargetLanguage</a></td>',
	ENDCODE		=> '</tr></table>'
};

$VerticalTable = {
	NAME			=> 'Vertical Table',
	SEPERATOR	=> '<br>',
	STARTCODE	=> '<table border="1" cellspacing="0" bordercolor="#000000" cellpadding="3" bgcolor="#C0C0C0" align="center">' .
						'<tr><td bgcolor="#000000" align="center">' .
						'<font color="#FFFFFF" face="verdana" size="2"><b>Language</b></font>' .
						'</td></tr><tr><td align="center"><font face="verdana" size="2">',
	MIDCODE		=> '<a href="$ScriptLocation?a=f&e=$Engine&p=$Pair&u=$PageURL">$TargetLanguage</a>',
	ENDCODE		=> '</font></td></tr></table>'
};

$ManualChange = {
	NAME			=> 'Drop-Down Manual Change',
	SEPERATOR	=> '',
	STARTCODE	=> '<form name="translingo" method="POST" action="$ScriptLocation">'.
						'<input type="hidden" name="a" value="f">'.
						'<input type="hidden" name="u" value="$PageURL">'.
						'<input type="hidden" name="p" value="">'.
						'<input type="hidden" name="e" value="">'.
						'<select name="l" size="1">',
	MIDCODE		=> '<option value="$Engine|$Pair">$TargetLanguage</option>',
	ENDCODE		=> '</select><input type="submit" value="Translate" onclick="f=document.translingo;n=f.l.selectedIndex;v=f.l[n].value;i=v.indexOf(\'|\');f.e.value=v.substring(0,i);f.p.value=v.substring(i+1);f.submit();"></form>'
};

$AutomaticChange = {
	NAME			=> 'Drop-Down Auto Change',
	SEPERATOR	=> '',
	STARTCODE	=> '<form name="translingo" method="POST" action="$ScriptLocation">'.
						'<input type="hidden" name="a" value="f">'.
						'<input type="hidden" name="u" value="$PageURL">'.
						'<input type="hidden" name="p" value="">'.
						'<input type="hidden" name="e" value="">'.
						'<select name="l" size="1" onChange="f=document.translingo;n=f.l.selectedIndex;if(n==0) return;v=f.l[n].value;i=v.indexOf(\'|\');f.e.value=v.substring(0,i);f.p.value=v.substring(i+1);f.submit();">'.
						'<option>$SourceLanguage</option>',
	MIDCODE		=> '<option value="$Engine|$Pair">$TargetLanguage</option>',
	ENDCODE		=> '</select></form>'
};

$ManualList = {
	NAME			=> 'Language List Manual Change',
	SEPERATOR	=> '',
	STARTCODE	=> '<form name="translingo" method="POST" action="$ScriptLocation">' .
						'<table border="0" cellspacing="0" cellpadding="0"><tr><td align="center">' .
						'<input type="hidden" name="a" value="f">' .
						'<input type="hidden" name="u" value="$PageURL">' .
						'<input type="hidden" name="p" value="">' .
						'<input type="hidden" name="e" value="">' .
						'<select name="l" size="$NumLanguages">',
	MIDCODE		=> '<option value="$Engine|$Pair">$TargetLanguage</option>',
	ENDCODE		=> '</select><br><input type="submit" value="Translate" onclick="f=document.translingo;n=f.l.selectedIndex;v=f.l[n].value;i=v.indexOf(\'|\');f.e.value=v.substring(0,i);f.p.value=v.substring(i+1);f.submit();">' .
						'</td></tr></table></form>'
};

$AutomaticList = {
	NAME			=> 'Language List Auto Change',
	SEPERATOR	=> '',
	STARTCODE	=> '<form name="translingo" method="POST" action="$ScriptLocation">' .
						'<table border="0" cellspacing="0" cellpadding="0"><tr><td align="center">' .
						'<input type="hidden" name="a" value="f">' .
						'<input type="hidden" name="u" value="$PageURL">' .
						'<input type="hidden" name="p" value="">' .
						'<input type="hidden" name="e" value="">' .
						'<select name="l" size="$NumLanguages" onChange="f=document.translingo;n=f.l.selectedIndex;v=f.l[n].value;i=v.indexOf(\'|\');f.e.value=v.substring(0,i);f.p.value=v.substring(i+1);f.submit();">',
	MIDCODE		=> '<option value="$Engine|$Pair">$TargetLanguage</option>',
	ENDCODE		=> '</select>' .
						'</td></tr></table></form>'
};

$RadioList = {
	NAME			=> 'Horizontal Radio Auto Change',
	SEPERATOR	=> '&amp;nbsp;&amp;nbsp;',
	STARTCODE	=> '<form name="translingo" method="POST" action="$ScriptLocation">'.
						'<input type="hidden" name="a" value="f">'.
						'<input type="hidden" name="u" value="$PageURL">'.
						'<input type="hidden" name="p" value="">'.
						'<input type="hidden" name="e" value="">'.
						'<input type="radio" value="" checked name="l">$SourceLanguage</option>&amp;nbsp;&amp;nbsp;',
	MIDCODE		=> '<input type="radio" value="$Engine|$Pair" name="l" onclick="_cl_(this)">$TargetLanguage</option>',
	ENDCODE		=> '</form><script language="JavaScript">function _cl_(r){f=document.translingo;v=r.value;i=v.indexOf(\'|\');f.e.value=v.substring(0,i);f.p.value=v.substring(i+1);f.submit();}</script>'
};

$VerticalRadioList = {
	NAME			=> 'Vertical Radio Auto Change',
	SEPERATOR	=> '<br>',
	STARTCODE	=> '<form name="translingo" method="POST" action="$ScriptLocation">'.
						'<input type="hidden" name="a" value="f">'.
						'<input type="hidden" name="u" value="$PageURL">'.
						'<input type="hidden" name="p" value="">'.
						'<input type="hidden" name="e" value="">'.
						'<input type="radio" value="" checked name="l">$SourceLanguage</option><br>',
	MIDCODE		=> '<input type="radio" value="$Engine|$Pair" name="l" onclick="_cl_(this)">$TargetLanguage</option>',
	ENDCODE		=> '</form><script language="JavaScript">function _cl_(r){f=document.translingo;v=r.value;i=v.indexOf(\'|\');f.e.value=v.substring(0,i);f.p.value=v.substring(i+1);f.submit();}</script>'
};

$Templates = {
		'a'		=> $Horizontal,
		'b'		=> $Vertical,
		'c'		=> $HorizontalTable,
		'd'		=> $VerticalTable,
		'e'		=> $ManualChange,
		'f'		=> $AutomaticChange,
		'g'		=> $ManualList,
		'h'		=> $AutomaticList,
		'i'		=> $RadioList,
		'j'		=> $VerticalRadioList
};
